% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.r
\name{build_ecotox_sqlite}
\alias{build_ecotox_sqlite}
\title{Build an SQLite database from zip archived tables downloaded from EPA website}
\usage{
build_ecotox_sqlite(source, destination = get_ecotox_path(), write_log = TRUE)
}
\arguments{
\item{source}{A \code{character} string pointing to the directory path where the text files with the raw
tables are located. These can be obtained by extracting the zip archive from \url{https://cfpub.epa.gov/ecotox/}
and look for 'Download ASCII Data'.}

\item{destination}{A \code{character} string representing the destination path for the SQLite file. By default
this is \code{\link[=get_ecotox_path]{get_ecotox_path()}}.}

\item{write_log}{A \code{logical} value indicating whether a log file should be written in the destination path
\code{TRUE}. The log contains information on the source and destination path, the version of this package,
the creation date, and the operating system on which the database was created.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} This function is called automatically after \code{\link[=download_ecotox_data]{download_ecotox_data()}}. The database
files can also be downloaded manually from the \href{https://cfpub.epa.gov/ecotox/}{EPA website} from which a local
database can be build using this function.
}
\details{
Raw data downloaded from the EPA website is in itself not very efficient to work with in R. The files are large
and would put a large strain on R when loading completely into the system's memory. Instead use this function
to build an SQLite database from the tables. That way, the data can be queried without having to load it all into
memory.

EPA provides the raw table from the \href{https://cfpub.epa.gov/ecotox/}{ECOTOX database} as text files with
pipe-characters ('|') as table column separators. Although not documented, the tables appear not to contain comment
or quotation characters. There are records containing the reserved pipe-character that will confuse the table parser.
For these records, the pipe-character is replaced with a dash character ('-').

In addition, while reading the tables as text files, this package attempts to decode the text as UTF8. Unfortunately,
this process appears to be platform-dependent, and may therefore result in different end-results on different platforms.
This problem only seems to occur for characters that are listed as 'control characters' under UTF8. This will have
consequences for reproducibility, but only if you build search queries that look for such special characters. It is
therefore advised to stick to common (non-accented) alpha-numerical characters in your searches, for the sake of
reproducibility.

Use '\code{\link[=suppressMessages]{suppressMessages()}}' to suppress the progress report.
}
\examples{
source_path <- tempfile()
dir.create(source_path)

## This is a small mockup file resembling the larger zip
## files that can be downloaded with `download_ecotox_data()`:

source_file <- system.file("ecotox-test.zip", package = "ECOTOXr")

unzip(source_file, exdir = source_path)

build_ecotox_sqlite(source_path, tempdir())
}
\seealso{
Other database-build-functions: 
\code{\link{check_ecotox_build}()},
\code{\link{check_ecotox_version}()},
\code{\link{download_ecotox_data}()},
\code{\link{get_ecotox_url}()}
}
\author{
Pepijn de Vries
}
\concept{database-build-functions}
