% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEM-misc.R
\name{EEM-misc}
\alias{EEM-misc}
\alias{generateColor}
\alias{generatePoint}
\alias{getEM}
\alias{getEX}
\title{Internal functions for EEM package}
\usage{
generatePoint(n, pch = NULL)

generateColor(n, color.palette = NULL)

getEX(string, digits = NULL)

getEM(string, digits = NULL)
}
\arguments{
\item{n}{number}

\item{pch}{Either an integer specifying a symbol or a single character to be used as the default in plotting points.}

\item{color.palette}{(optional) contour color palette. See \code{\link[grDevices]{palette}} for more details}

\item{string}{string or vector of strings}

\item{digits}{integer indicating the number of decimal places
    (\code{round}) or significant digits (\code{signif}) to be used.
    Negative values are allowed (see \sQuote{Details}).}
}
\description{
Internal functions for EEM package
}
\details{
`generatePoint` and `generateColor` are used to create point and color 
vector from specified number (n) and palette.
}
\section{Functions}{
\itemize{
\item \code{generateColor}: generate colors

\item \code{getEX}: get EX value

\item \code{getEM}: get EM value
}}

