% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAplate.R
\name{predictAll}
\alias{predictAll}
\title{Predict the concentration of samples based on fitting}
\usage{
predictAll(batches)
}
\arguments{
\item{batches}{list of elisa_batch objects containing 
both the raw data and the fitted regression model.}
}
\value{
The same list of elisa_batch with estimated
	sample concentrations based on ODs and the fitted regression
	model. The estimated concentrations normalized/corrected
	between different batches are also calculated and recorded.
}
\description{
Based on the 5pl or 4pl regression, predict the concentration of 
	of unknown samples. Assume the regression has been accomplished.
}
\details{
The input data structure contains both the data (ODs) and
	the fitted regression model. The estimation of unknonw concentration
	based on the ODs and the standard curve of each plate.  
	The batch effects are corrected/normalized and the corrected
	concentrations also are	also written into the batch data
	structure, if there are more than one batches in the data.
}
\references{
Feng 2018 \doi{10.1101/483800}
}
\seealso{
\code{\link{elisa_batch}} \code{\link{elisa_run}}
		\code{\link{elisa_plate}}
}
