% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqMCR.R
\name{qqMCR}
\alias{qqMCR}
\title{QQ-Plot of Residuals for MCR Model}
\usage{
qqMCR(
  object,
  type = c("cox-snell", "quantile"),
  envelope = FALSE,
  nsim = 100,
  censor = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{MCR}, typically returned by \code{\link{MCRfit}}.}

\item{type}{Character. Type of residual to use in the QQ-plot. Options are \code{"cox-snell"} or \code{"quantile"}. Defaults to \code{"cox-snell"}.}

\item{envelope}{Logical. Whether to add a simulation envelope to the QQ-plot. Default is \code{FALSE}.}

\item{nsim}{Integer. Number of simulations used to construct the envelope. Default is \code{100}.}

\item{censor}{Logical vector or NULL. Censoring indicator used when simulating data for the envelope. Required only when \code{envelope = TRUE} and \code{type = "cox-snell"}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A QQ-plot is produced as a side effect. Nothing is returned.
}
\description{
Produces a Q-Q plot of residuals from a Mixture Cure Rate (MCR) model fitted via \code{\link{MCRfit}}. Optionally, a simulation envelope can be included for Cox-Snell residuals.
}
\details{
The function generates QQ-plots of either Cox-Snell or quantile residuals. When \code{envelope = TRUE} and \code{type = "cox-snell"}, a simulation envelope is added using Monte Carlo replications.
}
\examples{

data(liver)
fit <- MCRfit(survival::Surv(time, status) ~ age + medh + relapse + grade | sex + grade,
              data = liver, dist = "weibull", link = "logit")
qqMCR(fit, type = "quantile", envelope = TRUE, nsim = 50, censor = liver$status)

}
\seealso{
\code{\link{MCRfit}}, \code{\link{residuals.MCR}}
}
