% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_likelihood.R
\name{calculate_likelihood}
\alias{calculate_likelihood}
\title{calculate_likelihood}
\usage{
calculate_likelihood(dat, params)
}
\arguments{
\item{dat}{An (n + 1) x (m + 1) data frame of finite numeric elements (possibly except for row 1, columns 1 to m) containing observed input (columns 1 to m) and output (column m + 1) data of the original model.}

\item{params}{A list consisting of three elements: 1) Sigma ((m + 1) x (m + 1) matrix of finite numeric elements); 2) sigma_y^2 (vector of length 1, finite numeric element); 3) mu ((m + 1) x 1 matrix of finite numeric elements).}
}
\value{
Calculated likelihood function value (vector of length 1, numeric element).
}
\description{
Calculates the likelihood function value for given data and statistical measure values of the output-differenced version of the single-output cumulative structural equation model with an additive-noise output measurement equation and assumptions of normality and independence. Suitable when there are no contradictions in statistical measure values.
}
\examples{
set.seed(1)

m <- 4
k <- 2

L <- matrix(runif((m + 1) * k, min = -10, max = 10), nrow = m + 1)
sigma <- matrix(runif(m + 2, min = 0, max = 10), nrow = m + 2)
mu <- matrix(runif(m + 1, min = -10, max = 10), nrow = m + 1)

data <- generate_data(100, L, sigma, mu)
estimated_parameters <- estimate_parameters(data, 0.00001)

calculate_likelihood(data, estimated_parameters)

}
