% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg_objective_function.R
\name{neg_objective_function}
\alias{neg_objective_function}
\title{Negative objective function for EMMIXSSL}
\usage{
neg_objective_function(
  dat,
  zm,
  g,
  par,
  ncov = 2,
  type = c("ign", "full", "com")
)
}
\arguments{
\item{dat}{An \eqn{n\times p} matrix where each row represents an individual observation}

\item{zm}{An n-dimensional vector of group partition including the missing-label, denoted as NA.}

\item{g}{Number of multivariate Gaussian groups.}

\item{par}{An informative vector including \code{mu}, \code{pi},\code{sigma} and \code{xi}.}

\item{ncov}{Options of structure of sigma matrix;  the default value is 2;
\code{ncov} = 1 for a common covariance matrix;
\code{ncov} = 2 for the unequal  covariance/scale matrices.}

\item{type}{Three types to fit to the model, 'ign' indicates fitting the model on the basis of the likelihood that ignores the missing label mechanism,
'full' indicates that the model to be fitted on the basis of the full likelihood, taking into account the missing-label mechanism,
and 'com' indicate that the model to be fitted to a completed classified sample.}
}
\value{
\item{val}{Value of negatvie objective function.}
}
\description{
Negative objective function for EMMIXSSL
}
