% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{sct3}
\alias{sct3}
\alias{sct3,binClst-method}
\title{Dynamic 3D-scatterplot}
\usage{
sct3(obj, ...)

\S4method{sct3}{binClst}(obj, showVars = NULL, showClst = NULL, ...)
}
\arguments{
\item{obj}{A \link{binClst_instance}.}

\item{...}{Parameters \code{ref}, \code{showVars} and \code{showClst} are
optional.}

\item{showVars}{When the number of variables is greater than two, a length 3
numeric vector indicating one splitting variable and two variables to be
scattered (given in that order).}

\item{showClst}{When the number of variables is greater than two, a numeric
vector (of variable length) indicating a subset of the clusters that will
be shown in the scatter plot. This is useful in case of overlapping
clusters.}
}
\description{
\code{sct3} generates a dynamic 3D-scatterplot of a multivariate
  \link{binClst_instance}, showing clusters in different colors. The scatter
  plot can be zoomed/rotated with the mouse.
}
\details{
This function needs the package "rgl" to be installed.
}
\examples{
\dontrun{
# -- apply EMbC to the example path with scv='height' --
mybcp <- stbc(expth,scv='height')
# -- show a dynamic 3D-scatterplot --
sct3(mybcp)
# -- show only a subset of clusters --
sct3(mybcp,showClst=c(2,4,6))
}
}
