% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{EQRN_predict_params}
\alias{EQRN_predict_params}
\title{GPD parameters prediction function for an EQRN_iid fitted object}
\usage{
EQRN_predict_params(
  fit_eqrn,
  X,
  intermediate_quantiles = NULL,
  return_parametrization = c("classical", "orthogonal"),
  interm_lvl = fit_eqrn$interm_lvl,
  device = default_device()
)
}
\arguments{
\item{fit_eqrn}{Fitted \code{"EQRN_iid"} object.}

\item{X}{Matrix of covariates to predict conditional GPD parameters.}

\item{intermediate_quantiles}{Vector of intermediate conditional quantiles at level \code{fit_eqrn$interm_lvl}.}

\item{return_parametrization}{Which parametrization to return the parameters in, either \code{"classical"} or \code{"orthogonal"}.}

\item{interm_lvl}{Optional, checks that \code{interm_lvl == fit_eqrn$interm_lvl}.}

\item{device}{(optional) A \code{\link[torch:torch_device]{torch::torch_device()}}. Defaults to \code{\link[=default_device]{default_device()}}.}
}
\value{
Named list containing: \code{"scales"} and \code{"shapes"} as numerical vectors of length \code{nrow(X)}.
}
\description{
GPD parameters prediction function for an EQRN_iid fitted object
}
