% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EVT_utils.R
\name{predict_unconditional_quantiles}
\alias{predict_unconditional_quantiles}
\title{Predict unconditional extreme quantiles using peaks over threshold}
\usage{
predict_unconditional_quantiles(interm_lvl, quantiles = c(0.99), Y, ntest = 1)
}
\arguments{
\item{interm_lvl}{Probability level at which the empirical quantile should be used as the intermediate threshold.}

\item{quantiles}{Probability levels at which to predict the extreme quantiles.}

\item{Y}{Vector of ("training") observations.}

\item{ntest}{Number of "test" observations.}
}
\value{
Named list containing:
\item{predictions}{matrix of dimension \code{ntest} times \code{length(quantiles)}
containing the estimated extreme quantile at levels \code{quantile}, repeated \code{ntest} times,}
\item{pars}{matrix of dimension \code{ntest} times \code{2}
containing the two GPD parameter MLEs, repeated \code{ntest} times.}
\item{threshold}{The threshold for the peaks-over-threshold GPD model.
It is the empirical quantile of \code{Y} at level \code{interm_lvl}, i.e. \code{stats::quantile(Y, interm_lvl)}.}
}
\description{
Predict unconditional extreme quantiles using peaks over threshold
}
