% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evirlap.R
\name{evirlap}
\alias{evirlap}
\title{Combining multiple epidemic volatility indices into a multi-early warning index plot}
\usage{
evirlap(
  Index1,
  Index2,
  ln = T,
  type = "p",
  size.index = 1,
  Index1.lab = "EVI1",
  Index2.lab = "EVI2",
  Index3.lab = "EVI-",
  Index.country = NULL
)
}
\arguments{
\item{Index1}{e.g. output of the \code{\link[EVI:deviant]{deviant()}} function}

\item{Index2}{e.g. output of the \code{\link[EVI:deviant]{deviant()}} function (e.g. method = cEVI)}

\item{ln}{TRUE or FALSE; If TRUE (the default) the output of the graph will be presented on the logarithmic scale. IF FALSE the output data will be presented on the original scale.}

\item{type}{By default, points are plotted on EVI graphs. In cases where, changes are very sudden or data sparsely available, type="l" introduces lines on top of points for the "EVI" type of graph.}

\item{size.index}{Size of the points, default=1}

\item{Index1.lab}{Text for index 1, "EVI1"}

\item{Index2.lab}{Text for index 2, "EVI2"}

\item{Index3.lab}{Text for index conjuction, "EVI-"}

\item{Index.country}{Label for country/area/region under analysis}
}
\value{
\itemize{
\item{evirlap: A graph with two EVI indexes shown simulteounsly.}}
}
\description{
This function returns an overlap graph containing two indices.
\enumerate{
\item If index number 1 results in an early warning,then a yellow point will be shown.
\item If index number 2 results in an early warning, then a orange point will be shown.
\item If both indexes result in early warnings, then a red point will be shown.
}
}
\details{
The evirlap function can literally combine any two indices with only 2 requirements. The two vectors (Index1, Index2) to be of equal length and to contain either 0s (no warnings) or 1s (warnings).

For each time point the stored variables are:
}
\examples{

# Run basic functions to acquire early warnings results
#data('Italy')
#EVI_output=deviant(new_cases=Italy$Cases, cum=FALSE, method="EVI")
#cEVI_output=deviant(new_cases=Italy$Cases, cum=FALSE, method="cEVI")

# Plot the EVI combination graph
#evirlap(Index1=EVI_output, Index2=cEVI_output, ln=TRUE)
#evirlap(Index1=EVI_output, Index2=cEVI_output, ln=TRUE, type="l") # For the line EVI plot

# Austria first 150 case example
#data('Austria')
#tmp_EVI_at=deviant(new_cases = Austria$Cases)
#tmp_cEVI_at=deviant(new_cases = Austria$Cases,lag_max = 40,method = "cEVI")
#evirlap(Index1 = tmp_EVI_at,Index2 = tmp_cEVI_at)

}
\references{
Pateras K, Meletis E, Denwood M, et al. The convergence epidemic index (cEVI) an early warning tool for identifying waves in an epidemic. Inf Dis Mod, (2023)
}
