% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{METAPOP_SIMULATION}
\alias{METAPOP_SIMULATION}
\title{Simulation of a metapopulation}
\usage{
METAPOP_SIMULATION(
  nbPop,
  ids,
  migMat,
  nsim,
  verbose,
  recording,
  recordGenGap,
  drift,
  nbHaplo,
  nbGeno,
  idGeno,
  nbAlleles,
  idAlleles,
  nbLoci,
  initGenoFreq,
  meiosisMat,
  gametogenesisMat,
  popSize,
  threshold,
  dioecy,
  selfRate,
  stopCondition,
  IDstopCondition,
  haploCrossMat,
  alleleFreqMat,
  gamFit,
  indFit,
  gamProdFit,
  demography,
  growthRate,
  initPopSize,
  nameOutFunct
)
}
\arguments{
\item{nbPop}{number of populations in the metapopulation}

\item{ids}{population IDs}

\item{migMat}{migration matrix}

\item{nsim}{number of simulations}

\item{verbose}{boolean determining if the progress of the simulations should be displayed or not (useful in case of many simulations)}

\item{recording}{a boolean indicating whether to record all mutations, i.e.
to record allelic and genotypic frequencies along the simulations}

\item{recordGenGap}{the number of generations between two records during
simulation, if the record parameter is TRUE. Whatever the value of this
parameter, both the first and the last generation will be included in
the record}

\item{drift}{a boolean indicating whether genetic drift should be
considered (i.e. whether deterministic simulations are performed or not)}

\item{nbHaplo}{number of haplotypes}

\item{nbGeno}{number of genotypes}

\item{idGeno}{genotypes ID}

\item{nbAlleles}{number of alleles for each loci}

\item{idAlleles}{alleles ID}

\item{nbLoci}{number of loci}

\item{initGenoFreq}{list of initial genotype frequencies in the populations}

\item{meiosisMat}{meiosis matrix}

\item{gametogenesisMat}{gametogenesis matrix}

\item{popSize}{list population sizes}

\item{threshold}{threshold for simulations}

\item{dioecy}{whether the population(s) is dioecious or not (hermaphrodism)}

\item{selfRate}{list of the selfing rate in populations (only for hermaphroditic population)}

\item{stopCondition}{list of stop conditions}

\item{IDstopCondition}{vector of stop condition ID}

\item{haploCrossMat}{haplotypes crossing matrix}

\item{alleleFreqMat}{matrix for calculating allelic frequencies}

\item{gamFit}{fitness of gametes}

\item{indFit}{fitness of individuals}

\item{gamProdFit}{fitness for gamete production}

\item{demography}{list of population demographies}

\item{growthRate}{list of population growth rates}

\item{initPopSize}{list of initial population}

\item{nameOutFunct}{name of the custom output function}
}
\description{
Simulation of a metapopulation
}
\author{
Ehouarn Le Faou
}
