% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{setPopulation}
\alias{setPopulation}
\title{Setting a population}
\usage{
setPopulation(
  name,
  size,
  dioecy,
  genomeObj,
  mutMatrixObj,
  selectionObj,
  selfRate = 0,
  demography = F,
  growthRate = 0,
  initPopSize = NULL,
  initGenoFreq = NULL
)
}
\arguments{
\item{name}{the name of the population}

\item{size}{the population size}

\item{dioecy}{logical indicating whether the simulated population is
dioecious or hermaphroditic}

\item{genomeObj}{a \code{Genome} object}

\item{mutMatrixObj}{a \code{MutationMatrix} object}

\item{selectionObj}{a \code{Selection} object}

\item{selfRate}{the selfing rate}

\item{demography}{a logic indicating whether the population should have
a demography (stochasticity in the number of individuals present in the
population + logistic growth with carrying capacity equal to the \code{size}
parameter)}

\item{growthRate}{a \code{Genome} object}

\item{initPopSize}{the initial size of the population. It is necessarily
equal to \code{size} if the population has no \code{demography}.}

\item{initGenoFreq}{a vector of the size of the genotype number
describing the initial allele frequencies common to all simulations}
}
\value{
a \code{Population} object
}
\description{
Generation of a population by providing all the necessary ingredients for
its definition, including a genome, a mutation matrix and a selection regime.
}
\details{
A population is defined strictly by a name, a size, a sexual system
(dioecy or hermaphodite), and the three objects defined previously:
genome, mutation matrix and selection. In addition to that, it is
possible to define
 - a selfing rate (by default equal to 0)
 - a vector of initial genotypic frequencies
 - a demography

Two demographic regimes are possible: no demography, i.e. a fixed population
size, or demography, i.e. a population where the size fluctuates
stochastically. The boolean argument `demography` is used to define whether
there should be stochasticity. For a fixed population size, it is therefore
sufficient to define that `demography = FALSE` (default) and to set the
desired population size with the `popSize` parameter.

For a fluctuating demography, `demography` must be `TRUE` and three other
parameters are then needed: the initial population size (`initPopSize`),
the population growth rate (`growthRate`) and the carrying capacity of the
population (the population size, `popSize`).

It is also possible to avoid defining a population size altogether, by
setting off the genetic drift (`drift` parameter). This will allow the
model to be simulated deterministically.
}
\examples{
# Definition of a population in its simplest form:
DL <- list(dl = c("A", "a"))
HL <- list(hl = c("B", "b"))
mutations <- list(
  mutation(from = "A", to = "a", rate = 1e-3),
  mutation(from = "B", to = "b", rate = 1e-3)
)
genomeObj <- setGenome(listHapLoci = HL, listDipLoci = DL)
pop <- setPopulation(
  name = "A",
  size = 1000,
  dioecy = TRUE,
  genomeObj = genomeObj,
  selectionObj = setSelectNeutral(genomeObj),
  mutMatrixObj = setMutationMatrix(genomeObj, mutations = mutations)
)

}
\author{
Ehouarn Le Faou
}
