% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_matrix.r
\name{get_matrix}
\alias{get_matrix}
\title{Create regions - industries matrices from regular data frames}
\usage{
get_matrix (my_data, sparse = FALSE)
}
\arguments{
\item{my_data}{is a data frame with three columns (regions, industries, count)}

\item{sparse}{Logical; shall the returned output be a sparse matrix? Defaults to FALSE, but can be set to TRUE if the dataset is very large}
}
\value{
A regions - industries matrix in either dense or sparse format, depending on the value of the "sparse" parameter
}
\description{
This function creates regions - industries (incidence) matrices from regular data frames (long to wide format) using the reshape2 package or the Matrix package
}
\examples{
## generate a region - industry data frame
set.seed(31)
region <- c("R1", "R1", "R1", "R1", "R2", "R2", "R3", "R4", "R5", "R5")
industry <- c("I1", "I2", "I3", "I4", "I1", "I2", "I1", "I1", "I3", "I3")
my_data <- data.frame(region, industry)
my_data$count <- 1

## run the function
get_matrix(my_data)
get_matrix(my_data, sparse = TRUE)
}
\seealso{
\code{\link{get_list}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{data.management}
