% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_docu.R
\docType{data}
\name{plebiscite}
\alias{plebiscite}
\title{Chilean Plebiscite}
\format{A data frame with 2431 observations on the following 7 variables.
\describe{ \item{Gender}{Gender with levels \code{female} and
\code{male}} 
\item{Education}{Educational level with levels
\code{low} and \code{high}} 
\item{SantiagoCity}{Respondent from
Santiago City with levels \code{no} and \code{yes}}
\item{Income}{(Standardized) Monthly Income in Pesos}
\item{Population}{(Standardized) Population size of respondent's community}
\item{Age}{(Standardized) Age in years} 
\item{Vote}{Response with levels
\code{Abstention}, \code{No}, \code{Undecided} and \code{Yes}} }}
\source{
R package carData: \code{\link[carData]{Chile}}
}
\description{
The data origin from a survey refering to the plebiscite in Chile 1988. The
chilean people had to decide, wether Augusto Pinochet would remain president
for another ten years (voting yes) or if there would be presidential
elections in 1989 (voting no).
}
\examples{

\dontrun{
data(plebiscite)
m_chile <- vglm(Vote ~ ., family = multinomial(), data = plebiscite)

effectstars(m_chile)
}

}
\references{
Fox, J. (2008):
\emph{Applied Regression Analysis and Generalized Linear Models}, Second
Edition.
}
\keyword{datasets}
\keyword{multinomial}
\keyword{response}
