% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_simulation_output}
\alias{format_simulation_output}
\title{Format Simulation Output from Stan}
\usage{
format_simulation_output(
  stan_fit,
  data,
  reported_dates,
  imputed_dates,
  reported_inf_dates,
  drop_length_1 = FALSE,
  merge = FALSE
)
}
\arguments{
\item{stan_fit}{A \verb{<stanfit>} or \verb{<CmdStanMCMC>} object as returned by
\code{\link[=fit_model]{fit_model()}}.}

\item{data}{A list of the data supplied to the simulation.}

\item{reported_dates}{A vector of dates to report estimates for.}

\item{imputed_dates}{A vector of dates to report imputed reports for.}

\item{reported_inf_dates}{A vector of dates to report infection estimates
for.}

\item{drop_length_1}{Logical; drop dimensions of length 1 in arrays extracted
from the stan fit. Used in simulations where there's only 1 realization.}

\item{merge}{if TRUE, merge samples into a single data.table using
rbindlist. If FALSE returns a list of samples by parameter.}
}
\value{
A list of \verb{<data.frame>}'s each containing the simulated trajectories
of each parameter, or a single merged data.table if merge = TRUE.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Formats simulation output from Stan models into structured data.tables with
dates. This is an internal function used by \code{\link[=simulate_infections]{simulate_infections()}} and
\code{\link[=forecast_infections]{forecast_infections()}} to process simulation results.

This differs from \code{\link[=get_samples]{get_samples()}} in that it's designed for simulation
outputs which have different array structures (especially with
\code{drop_length_1 = TRUE}) and need different date ranges for different
parameters.
}
\keyword{internal}
