% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_common.R
\name{pmm2_algorithm}
\alias{pmm2_algorithm}
\title{Universal PMM2 algorithm for all model types}
\usage{
pmm2_algorithm(
  b_init,
  X,
  y,
  m2,
  m3,
  m4,
  max_iter = 50,
  tol = 1e-06,
  regularize = TRUE,
  reg_lambda = 1e-08,
  verbose = FALSE,
  poly_terms = NULL
)
}
\arguments{
\item{b_init}{Initial parameter estimates}

\item{X}{Design matrix}

\item{y}{Response vector}

\item{m2, m3, m4}{Central moments}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Tolerance for convergence}

\item{regularize}{Whether to add regularization}

\item{reg_lambda}{Regularization parameter}

\item{verbose}{Whether to print progress information}

\item{poly_terms}{Pre-computed polynomial coefficients (list with elements \code{A}, \code{B}, \code{C});
allows passing custom values for special scenarios, otherwise they are computed from moments}
}
\value{
List with estimation results
}
\description{
Universal PMM2 algorithm for all model types
}
\keyword{internal}
