% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearest.R
\name{linearest}
\alias{linearest}
\title{Estimates using polynomial equations.}
\usage{
linearest(indep, dep, type = NULL, alpha = 0.05, verbose = FALSE)
}
\arguments{
\item{indep}{Name of the column with the independent variable.}

\item{dep}{Name of the dependent variable column}

\item{type}{Type of analysis to be carried out. Use 'MTE' to extract the
maximum technical efficiency or 'plateau' for plateau regression.}

\item{alpha}{Significance of the test.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}
}
\value{
Calculates the maximum technical efficiency (MTE) based on a quadratic
polynomial model, if it is significant. The MTE is given by:
\deqn{MTE = -\frac{\beta_1}{2\beta_2}}

It also calculates plateau regression parameters, returning:
- The plateau value: \deqn{Y_{plateau} = \beta_0 + \beta_1 X_{plateau} + \beta_2 X_{plateau}^2}
- The growth rate: \deqn{\beta_1}
- The inflection point: \deqn{X_{inflection} = -\frac{\beta_1}{2\beta_2}}
}
\description{
Determination of maximum technical efficiency (MTE) and plateau regression.
}
\examples{
library(EstimateBreed)
data("mtcars")

met<-with(mtcars,linearest(wt,mpg,type = "MTE",verbose=TRUE))
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
