% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snk.evaluate.core.R
\name{snk.evaluate.core}
\alias{snk.evaluate.core}
\title{Student-Newman-Keuls Test}
\usage{
snk.evaluate.core(data, names, quantitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
A data frame with the following components. \item{Trait}{The
  quantitative trait.} \item{Count}{The accession count (excluding missing
  data).} \item{Df}{The degrees of freedom for the test.} \item{EC_Min}{The
  minimum value of the trait in EC.} \item{EC_Max}{The maximum value of the
  trait in EC.} \item{EC_Mean}{The mean value of the trait in EC.}
  \item{EC_SE}{The standard error of the trait in EC.} \item{CS_Min}{The
  minimum value of the trait in CS.} \item{CS_Max}{The maximum value of the
  trait in CS.} \item{CS_Mean}{The mean value of the trait in CS.}
  \item{CS_SE}{The standard error of the trait in CS.} \item{SNK_pvalue}{The
  p value of the Student-Newman-Keuls test for equality of means of EC and
  CS.} \item{SNK_significance}{The significance of the Student-Newman-Keuls
  test for equality of means of EC and CS.}
}
\description{
Test difference between means of entire collection (EC) and core set (CS) for
quantitative traits by Newman-Keuls or Student-Newman-Keuls test
\insertCite{newman_distribution_1939,keuls_use_1952}{EvaluateCore}.
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

snk.evaluate.core(data = ec, names = "genotypes",
                  quantitative = quant, selected = core)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[agricolae]{SNK.test}}
}
