% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supplementalProjection.R
\name{supplementalProjection}
\alias{supplementalProjection}
\title{Supplemental projections.}
\usage{
supplementalProjection(sup.transform = NULL, f.scores = NULL, Dv =
NULL, scale.factor = NULL, symmetric = TRUE)
}
\arguments{
\item{sup.transform}{Data already transformed for supplementary projection.
That is, the output from: \code{\link{caSupplementalElementsPreProcessing}},
\code{\link{mdsSupplementalElementsPreProcessing}},
\code{\link{pcaSupplementaryColsPreProcessing}}, or
\code{\link{pcaSupplementaryRowsPreProcessing}}.}

\item{f.scores}{Active factor scores, e.g., res$ExPosition.Data$fi}

\item{Dv}{Active singular values, e.g., res$ExPosition.Data$pdq$Dv}

\item{scale.factor}{allows for a scaling factor of supplementary
projections. Primarily used for MCA supplemental projections to a correction
(e.g., Benzecri).}

\item{symmetric}{a boolean. Default is TRUE. If FALSE, factor scores are
computed with asymmetric properties (for rows only).}
}
\value{
A list with: \cr \item{f.out}{Supplementary factor scores.}
\item{d.out}{Supplementary square distances.} \item{r.out}{Supplementary
cosines.}
}
\description{
Performs a supplementary projection across ExPosition (and related)
techniques.
}
\seealso{
It is preferred for users to compute supplemental projections via
\code{\link{supplementaryRows}} and \code{\link{supplementaryCols}}. These
handle some of the nuances and subtleties due to the different methods.
}
\author{
Derek Beaton
}
\keyword{misc}
\keyword{multivariate}
