% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_lbga.R
\name{recombination_lbga}
\alias{recombination_lbga}
\title{Linear BGA recombination for DE}
\usage{
recombination_lbga(X, M, ...)
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{...}{optional parameters (unused)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/lbga" (Linear Breeder Genetic Algorithm) recombination for 
the ExpDE framework
}
\section{Warning}{

This recombination operator evaluates the candidate solutions in \code{M}, 
which adds an extra \code{popsize} evaluations per iteration.
}

\section{References}{

F. Herrera, M. Lozano, A. M. Sanchez, "A taxonomy for the crossover
operator for real-coded genetic algorithms: an experimental study", 
International Journal of Intelligent Systems 18(3) 309-338, 2003.\cr
D. Schlierkamp-voosen , H. Muhlenbein, "Strategy Adaptation by 
Competing Subpopulations", Proc. Parallel Problem Solving from Nature 
(PPSN III), 199-208, 1994.
}

