% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code2.R
\name{ExtractByPoint}
\alias{ExtractByPoint}
\title{Add a Point shapefile and raster image.}
\usage{
ExtractByPoint(img, point.shp, In.colName, Out.colName)
}
\arguments{
\item{img}{Raster image}

\item{point.shp}{Point shapefile with class info}

\item{In.colName}{Name of the column contain point id's}

\item{Out.colName}{Name of the output column contain point id's}
}
\description{
Add a Point shapefile and raster image.
}
\examples{
library(raster)
library(ExtractTrainData)
img<-brick(system.file("extdata","ras.tif",package = "ExtractTrainData"))
point.shp<-shapefile(system.file("extdata","poin.shp",package = "ExtractTrainData"))
Out.colName<-In.colName<-"Id"
ExtractByPoint(img,point.shp,In.colName,Out.colName)
}
\author{
Subhadip Datta
}
