% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_results_function.R
\name{return.results}
\alias{return.results}
\title{Return Final Results}
\usage{
return.results(homedir, mrun)
}
\arguments{
\item{homedir}{A string giving the directory in which the result folders are found. This is the same directory in which \code{\link{famos}} was run.}

\item{mrun}{The number of the FAMoS run that is to be evaluated. Must be a three digit string in the form of '001'. Alternatively, supplying 'best' will return the best result that is found over several FAMoS runs.}
}
\value{
A list containing the following elements:
\describe{
  \item{SCV}{The value of the selection criterion of the best model.}
  \item{par}{The values of the fitted parameter vector corresponding to the best model.}
  \item{binary}{The binary information of the best model.}
  \item{vector}{Vector indicating which parameters were fitted in the best model.}
  \item{total.models.tested}{The total number of different models that were analysed. May include repeats.}
  \item{mrun}{The number of the current FAMoS run.}
  \item{initial.mode}{The first model evaluated by the FAMoS run.}
}
}
\description{
Returns the results of one FAMoS run. Includes the best parameter sets and corresponding selection criterion.
}
\examples{
#setting data
x.values <- 1:7
y.values <-  3^2 * x.values^2 - exp(2 * x.values)

#define initial conditions and corresponding test function
inits <- c(p1 = 3, p2 = 4, p3 = -2, p4 = 2, p5 = 0)

cost_function <- function(parms, x.vals, y.vals){
 if(max(abs(parms)) > 5){
   return(NA)
 }
 with(as.list(c(parms)), {
   res <- p1*4 + p2^2*x.vals^2 + p3*sin(x.vals) + p4*x.vals - exp(p5*x.vals)
   diff <- sum((res - y.vals)^2)
 })
}


#perform model selection
res <- famos(init.par = inits,
           fit.fn = cost_function,
           nr.of.data = length(y.values),
           homedir = tempdir(),
           init.model.type = c("p2", "p3"),
           optim.runs = 1,
           x.vals = x.values,
           y.vals = y.values)

#get results
return.results(homedir = tempdir(), mrun = res$mrun)

#delete tempdir
unlink(paste0(tempdir(),"/FAMoS-Results"), recursive = TRUE)
}
