% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.sim.R
\name{sample.sim}
\alias{sample.sim}
\title{Generate random sample with different proportion of outliers and leverage points}
\usage{
sample.sim(n, p, sig, a1, a2, nn = TRUE, intercept = FALSE)
}
\arguments{
\item{n}{number of observations.}

\item{p}{number of independent variables (predictors).}

\item{sig}{variance of dependent variable.}

\item{a1}{proportion of outliers.}

\item{a2}{proportion of leverage points in outliers.}

\item{nn}{whether coefficients are non-negative, default TRUE.}

\item{intercept}{whether intercept is included in model, default TRUE.}
}
\value{
y:  vector of dependent variable.

x:  matrix of predictors with n rows and p columns.

loc:  index of added outliers.

beta: vector of coefficients.
}
\description{
Generate random sample with different proportion of outliers and leverage points
}
\examples{
library(FARDEEP)
samp = sample.sim(n = 500, p = 20, sig = 1, a1 = 0.1, a2 = 0.2, nn = TRUE, intercept = TRUE)
}
\references{
Yuning Hao, Ming Yan, Blake R. Heath, Yu L. Lei and Yuying Xie. Fast and Robust Deconvolution of Tumor Infiltrating Lymphocyte from Expression Profiles using Least Trimmed Squares. <doi:10.1101/358366>
}
\author{
Yuning Hao, Ming Yan, Blake R. Heath, Yu L. Lei and Yuying Xie
}
