% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{fdr.avepow}
\alias{fdr.avepow}
\title{Compute FDR and average power for a given sample size and effect size vector}
\usage{
fdr.avepow(n, avepow.func, null.hypo, alpha = 1:100/1000, method = "BH", ...)
}
\arguments{
\item{n}{sample size}

\item{avepow.func}{function to compute average power}

\item{null.hypo}{string to evaluate null hypothesis}

\item{alpha}{p-value threshold(s) to consider}

\item{method}{method to estimate proportion pi0 of tests with a true null hypothesis, including: "HH" (p-value histogram height) , "HM" (p-value histogram mean), "BH" (Benjamini & Hochberg 1995), "Jung" (Jung 2005)}

\item{...}{additional arguments, including effect size vector for average power function}
}
\value{
A list with the following components:
\item{n}{input sample size}
\item{avepow.func}{average power function}
\item{null.hypo}{null hypothesis string}
\item{pi0}{computed value of pi0}
\item{method}{method to estimate proportion \code{pi0} of tests with true null, including: "HH" (p-value histogram height) , "HM" (p-value histogram mean), "BH" (Benjamini & Hochberg 1995), "Jung" (Jung 2005)}
\item{other.args}{additional arguments}
\item{res.tbl}{table of alpha, fdr, and average power}
}
\description{
For a given fixed sample size and effect size vector,compute FDR and average power as a function of the p-value threshold alpha.
}
\examples{
n = 50; # number of events
logHR = rep(c(0,0.5),c(950,50));
v = rep(1,length(logHR));  # variance of predictor variable (vector)
res = fdr.avepow(n,average.power.coxph,"logHR==0",logHR=logHR,v=v);
res$pi0;
head(res$res.tbl)
}
\references{
Pounds S and Cheng C, "Sample size determination for the false discovery rate." Bioinformatics 21.23 (2005): 4263-4271.

Gadbury GL, et al. (2004) Power and sample size estimation in high dimensional biology. Statistical Methods in Medical Research 13(4):325-38.

Jung,Sin-Ho."Sample size for FDR-control in microarray data analysis." Bioinformatics 21.14 (2005): 3097-3104.

Ni Y, Seffernick A, Onar-Thomas A, Pounds S.  "Computing Power and Sample Size for the False Discovery Rate in Multiple Applications", Manuscript.
}
