% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackscholes_price.R
\name{BlackScholesPrice}
\alias{BlackScholesPrice}
\title{Calculate Black-Scholes option price}
\usage{
BlackScholesPrice(
  strike = forward,
  spot,
  texp = 1,
  sigma,
  intr = 0,
  divr = 0,
  cp = 1L,
  forward = spot * exp(-divr * texp)/df,
  df = exp(-intr * texp)
)
}
\arguments{
\item{strike}{(vector of) strike price}

\item{spot}{(vector of) spot price}

\item{texp}{(vector of) time to expiry}

\item{sigma}{(vector of) volatility}

\item{intr}{interest rate (domestic interest rate)}

\item{divr}{dividend/convenience yield (foreign interest rate)}

\item{cp}{call/put sign. \code{1} for call, \code{-1} for put.}

\item{forward}{forward price. If given, \code{forward} overrides \code{spot}}

\item{df}{discount factor. If given, \code{df} overrides \code{intr}}
}
\value{
option price
}
\description{
Calculate Black-Scholes option price
}
\examples{
spot <- 100
strike <- seq(80,125,5)
texp <- 1.2
sigma <- 0.2
intr <- 0.05
FER::BlackScholesPrice(strike, spot, texp, sigma, intr=intr)

}
\references{
Black, F., & Scholes, M. (1973). The Pricing of Options and
  Corporate Liabilities. Journal of Political Economy, 81(3), 637-654.
  \doi{10.1086/260062}

  Black, F. (1976). The pricing of commodity contracts. Journal of Financial
  Economics, 3(1), 167-179. \doi{10.1016/0304-405X(76)90024-6}

  \url{https://en.wikipedia.org/wiki/Black-Scholes_model}
}
\seealso{
\code{\link{BlackScholesImpvol}}
}
