% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfkml.R
\name{SFclust.permute}
\alias{SFclust.permute}
\title{Perform Permutation-Based Clustering Evaluation for SFclust}
\usage{
SFclust.permute(dist.ary, k, nperms, l1b)
}
\arguments{
\item{dist.ary}{A 3-dimensional distance array representing pairwise distances
between trajectories across multiple variables. Follows the same format used in \code{SFclust}.}

\item{k}{An integer specifying the number of clusters.}

\item{nperms}{An integer specifying the number of permutations to perform.}

\item{l1b}{A numeric vector of \eqn{\ell_1} norm constraint values to test during clustering. These values
control the sparsity of the weights during clustering.}
}
\value{
A list containing the following components:
\describe{
\item{totss}{A numeric vector of total within-cluster sum of squared distances for each \eqn{\ell_1} norm value.}
\item{permtotss}{A matrix of total sum of squared distances for each permutation and each \eqn{\ell_1} norm value.}
\item{nnonzerowss}{A numeric vector of the number of nonzero weights for each \eqn{\ell_1} norm value.}
\item{gaps}{A numeric vector of gap statistics: the difference between observed and permuted clustering results.}
\item{sdgaps}{A numeric vector of standard deviations of the gaps across permutations.}
\item{l1bounds}{A vector of \eqn{\ell_1} norm constraint values that were successfully processed without error.}
\item{bestl1b}{The \eqn{\ell_1} norm constraint value that yielded the largest gap.}
\item{failed_j}{Indices of \code{l1b} values that caused errors during the clustering process.}
\item{failed_l1b}{The actual \eqn{\ell_1} norm values that caused errors.}
\item{gapplot.l1b}{A ggplot object showing the gap statistics plotted against \eqn{\ell_1} norm constraint values.}
\item{gapplot.nnz}{A ggplot object showing the gap statistics plotted against the number of nonzero weights.}
}
}
\description{
Performs a permutation-based analysis to evaluate clustering results across different
values of the \eqn{\ell_1} norm constraint (\code{s}). This function is designed to help determine the
most appropriate \eqn{\ell_1} norm value by comparing the observed clustering outcome with those
obtained under random permutations.

The function computes gap statistics for each \eqn{\ell_1} norm constraint value based on permuted
versions of the input distance array, and identifies the optimal \code{s} as the one
maximizing the gap statistic. Two ggplot objects are returned to visualize the gap patterns.
}
\details{
This function helps assess the robustness of clustering structure and select an optimal level of sparsity.
If any clustering attempt fails (e.g., due to convergence issues or weight update errors), the corresponding
\code{l1b} values are reported in \code{failed_l1b} and \code{failed_j}.
This function returns two ggplot objects (\code{gapplot.l1b} and \code{gapplot.nnz}) that can be used to visualize the
gap statistics. These are not automatically printed, allowing users to decide when and how to display them.
This function involves random sampling internally. For reproducible results, set the random seed before calling the function using \code{set.seed()}.
}
