% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsetc.R
\name{plot_variables}
\alias{plot_variables}
\title{Plot variables in the Canonical Factor Loadings Space}
\usage{
plot_variables(res.mrcc, i, j, inner_circle_radius = 0.5, text_size = 0.8)
}
\arguments{
\item{res.mrcc}{List containing a canonical structure provided by the function frcc.}

\item{i}{Canonical Factor Loadings which will be used as the horizontal axis.}

\item{j}{Canonical Factor Loadings  which will be used as the vertical axis.}

\item{inner_circle_radius}{Radius of the circle which is used to determine
which variables are significant. Only the significant variables will be labeled.}

\item{text_size}{Character expansion factor for the labels of the variables.}
}
\value{
This function just creates the variables plot. It does not return a value.
}
\description{
This function plots the variables used in the FRCCA as points in a two-dimensional
plane in which the axis are the canonical factor loadings selected by the user.
}
\examples{
# Example: Multivariate Normal Data
p<-10
q<-10
n<-50
res<-generate_multivariate_normal_sample(p,q,n)
X<-res$X
Y<-res$Y
rownames(X)<-c(1:n)
colnames(X)<-c(1:p)
colnames(Y)<- c(1:q)
my_res<-frcc(X,Y)
grDevices::dev.new()
plot_variables(my_res,1,2,text_size=1.0)
}
\references{
Cruz-Cano, R.; Lee, M.L.T.; Fast Regularized Canonical Correlation Analysis,
Computational Statistics & Data Analysis, Volume 70, 2014, Pages 88-100,
ISSN 0167-9473, https://doi.org/10.1016/j.csda.2013.09.020.
}
\author{
Raul Cruz-Cano
}
