% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_assessment.R
\name{ess_rand}
\alias{ess_rand}
\title{Randomization-based Effective Sample Size (ESS)}
\usage{
ess_rand(assign_array, Y_mat, contrast = c(1, -1))
}
\arguments{
\item{assign_array}{A three dimensional array containing a set of independent realizations of a
collection the designs. The first coordinate of the array represents the iterations for
each design. The second coordinate represents the units. The third coordinate represents the design.}

\item{Y_mat}{A matrix of potential outcomes, where rows represent units and columns represent treatment
levels (ordered).}

\item{contrast}{A vector of the coefficients of the treatment contrast of interest. For example, for estimating the
average treatment effect of treatment 1 versus treatment 2, \code{contrast = c(1,-1)}.}
}
\value{
A vector of effective sample sizes for the given collection of assignments.
}
\description{
Computes the randomization-based effective sample size (ESS) of a collection of assignments 
under a given set of potential outcomes.
}
\examples{
# Consider N = 12, n1 = n2 = 6.
df_sample = data.frame(index = 1:12, x = c(20,30,40,40,50,60,20,30,40,40,50,60))
# Generate the potential outcomes.
Y_1 = 100 + (df_sample$x - mean(df_sample$x)) + rnorm(12, 0, 4)
Y_2 = Y_1 + 50
# Create matrix of potential outcomes.
Y_appended = cbind(Y_1, Y_2)
# Generate 100 assignments under CRD and the FSM.
Z_crd_iter = matrix(rep(0, 100 * 12), nrow = 100)
Z_fsm_iter = matrix(rep(0, 100 * 12), nrow = 100)
for(i in 1:100)
{
# Generate an assignment vector under CRD.
fc = crd(data_frame = df_sample, n_treat = 2, treat_sizes = c(6,6), control = FALSE)
Z_crd_iter[i,] = fc$Treat
# Generate an assignment vector under the FSM.
som_iter = som(data_frame = NULL, n_treat = 2, 
treat_sizes = c(6, 6),include_discard = FALSE,
method = 'SCOMARS', marginal_treat = rep((6/12), 12), control = FALSE)
f = fsm(data_frame = df_sample, SOM = som_iter, s_function = 'Dopt',eps = 0.0001, 
ties = 'random', intercept = TRUE, standardize = TRUE, units_print = FALSE)
Z_fsm_iter[i,] = f$data_frame_allocated$Treat
}
# Create a 3-dim array of assignments.
Z_array = array(0, dim = c(100, 12, 2))
Z_array[,,1] = Z_crd_iter
Z_array[,,2] = Z_fsm_iter
# Calculate the ESS.
ess_rand(assign_array = Z_array, Y_mat = Y_appended, contrast = c(1,-1))
}
\references{
Chattopadhyay, A., Morris, C. N., and Zubizarreta, J. R. (2020), ``Randomized and Balanced Allocation 
of Units into Treatment Groups Using the Finite Selection Model for \code{R}".
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta.
}
