% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFSM.R
\name{ReliefFeatureSetMeasure}
\alias{ReliefFeatureSetMeasure}
\title{Relief Feature Set Measure evaluation measure}
\usage{
ReliefFeatureSetMeasure(iterations = 5, kNeightbours = 4)
}
\arguments{
\item{iterations}{Number of iterations}

\item{kNeightbours}{Number of neighbours}
}
\value{
Returns a function that is used to generate an evaluation set measure (between -1 and 1) using RFSM value for the selected features.
}
\description{
Generates an evaluation function that applies Feature set measure based on Relief (set measure). Described in \insertCite{Arauzo2004}{FSinR}. This function is called internally within the \code{\link{filterEvaluator}} function.
}
\examples{
\donttest{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly to evaluate a set of features
## Classification problem

# Generate the evaluation function with Cramer
RFSM_evaluator <- ReliefFeatureSetMeasure()
# Evaluate the features (parameters: dataset, target variable and features)
RFSM_evaluator(iris,'Species',c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width'))
}
}
\references{
\insertAllCited{}
}
\author{
Alfonso Jiménez-Vílchez
}
