% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectKBest}
\alias{selectKBest}
\title{Select K best}
\usage{
selectKBest(k = 1)
}
\arguments{
\item{k}{Number (positive integer) of returned features}
}
\value{
Returns a direct search function that is used in the feature selection process.
}
\description{
Generates a direct search function that takes the 'k' features with the greatest evaluations (The features evaluation is individual). This function is called internally within the \code{\link{directSearchAlgorithm}} function.
}
\examples{
\donttest{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a direct search process
## Classification problem


# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('IEConsistency')

# Generates the direct search function with k-best
skb_direct_search <- selectKBest()
# Performs the direct search process directly (parameters: dataset, target variable and evaluator)
skb_direct_search(iris, 'Species', filter_evaluator)
}
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
