% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_far.R
\name{gof_far}
\alias{gof_far}
\title{Goodness-of-fit test for FAR(1)}
\usage{
gof_far(
  f_data,
  H = 10,
  M = NULL,
  alpha = 0.05,
  pplot = FALSE,
  residual = FALSE,
  suppress_raw_output = FALSE,
  suppress_print_output = FALSE
)
}
\arguments{
\item{f_data}{A \eqn{J \times N} matrix of functional time series data, where \eqn{J} is the number of discrete points in a grid and \eqn{N} is the sample size.}

\item{H}{A positive integer specifying the maximum lag for which test statistics are computed.}

\item{M}{A positive integer specifying the number of Monte Carlo simulations used to approximate the null distribution.
If \eqn{M = NULL, M = \text{floor}((\max(150 - N, 0) + \max(100 - J, 0) + (J / \sqrt{2})))},
ensuring that the number of Monte Carlo simulations is adequate based on the dataset size.}

\item{alpha}{A numeric value between 0 and 1 specifying the significance level.}

\item{pplot}{A Boolean value. If TRUE, the function will produce a plot of p-values of the test
as a function of maximum lag \eqn{H}, ranging from \eqn{H=1} to \eqn{H=20}, which may increase the computation time.}

\item{residual}{A data frame. If TRUE, the function will provide the residuals obtained from fitting the FAR(1) model.}

\item{suppress_raw_output}{A Boolean value, FALSE by default. If TRUE, the function will not return the list
containing the p-value, quantile, and statistic.}

\item{suppress_print_output}{A Boolean value, FALSE by default. If TRUE, the function will not print any
output to the console.}
}
\value{
If suppress_raw_output = FALSE, a list containing the test statistic, the \eqn{(1-\alpha)} quantile of the
limiting distribution, and the p-value computed from the specified hypothesis test. Also prints output
containing a short description of the test, the p-value, and additional information about the test if
suppress_print_output = FALSE.
}
\description{
It fits a FAR(1) model and then assesses the cumulative significance of lagged
autocovariance operators from the model residuals, up to a user-selected maximum lag \eqn{H}.
}
\examples{
\donttest{
yd_far <- dgp.far(J=50, N=100, S=0.7, p=2, kernel = "Gaussian", burn_in = 50)
gof_far(yd_far, H=5, pplot=TRUE)
}
}
\references{
[1] Kim, M., Kokoszka, P., & Rice, G. (2023). White noise testing for functional time series. Statistic Surveys, 17, 119-168.
}
