% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.fvddp}
\alias{print.fvddp}
\title{Print hyperparameters and values from Fleming-Viot Dependent Dirichlet Processes}
\usage{
\method{print}{fvddp}(x, ...)
}
\arguments{
\item{x}{The \code{fvddp} object to be printed.}

\item{...}{Optional arguments for \code{summary} methods.}
}
\value{
A list of the hyperparameters of the process, i.e. \code{theta}, \code{P0.sample},
\code{Po.density}, and \code{is.atomic}. Moreover, if the process is still empty, this
will be printed; if otherwise it has been updated (via \code{\link[=update]{update()}}),
then the values in \code{y.star}, \code{M} and \code{w} will be printed.
}
\description{
Print hyperparameters and values from Fleming-Viot Dependent Dirichlet Processes
}
\examples{
#a simple example
FVDDP = initialize(theta = 1, sampling.f = function(x) rpois(x, 3),
                   density.f = function(x) dpois(x, 3), atomic = TRUE)
FVDDP = update(FVDDP, c(4,5))
print(FVDDP)

#in case there are no data
FVDDP=initialize(theta = 3, function(x) rnorm(x, -1, 3),
                 function(x) dnorm(x, -1, 3), atomic = FALSE)
print(FVDDP)
}
