\name{simfam2}
\alias{simfam2}
\title{
Generate familial time-to-event data with Kinship or IBD matrices.
}
\description{
Generate familial time-to-event data from correlated fraily model with Kinship or/and IBD matrices given pedigree data.
}
\usage{
simfam2(inputdata = NULL, IBD = NULL, design = "pop", variation = "none", depend = NULL, 
base.dist = "Weibull", base.parms = c(0.016, 3), var_names = c("gender", "mgene"), 
vbeta = c(1, 1), agemin = 20, hr = NULL)
% \method{summary}{simulation}(object, \dots)
}

\arguments{
  \item{inputdata}{
Dataframe contains variables \code{famID, indID, gender, motherID, fatherID, proband}, 
\code{generation, currentage} and other variables to be used in generating time-to-event data.
}
  \item{IBD}{
  IBD matrix
  }
  \item{design}{
Family based study design used in the simulations. Possible choices are: \code{"pop"}, \code{"pop+"}, \code{"cli"}, \code{"cli+"}, \code{"twostage"}, or \code{"noasc"}, where \code{"pop"} is for the population-based design that families are ascertained by affected probands, \code{"pop+"} is similar to \code{"pop"} but with mutation carrier probands, \code{"cli"} is for the clinic-based design that includes affected probands with at least one parent and one sib affected, \code{"cli+"} is similar to \code{"cli"} but with mutation carrier probands,  \code{"twostage"} for two-stage design that randomly samples families from the population in the first stage and oversamples high risk families in the second stage that include at least two affected members in the family, and \code{"noasc"} for no ascertainment correction that families are from simple random sampling. Default is \code{"pop"}.
}
  \item{variation}{
Source of residual familial correlation.  Possible choices are: \code{"kinship"} for correlated frailties within families generated by kinship matrix, \code{"IBD"} for correlated frailties by IBD matrix, \code{c("kinship", "IBD")} by both kinship and IBD matrices, or \code{"none"} for no residual familial correlation. Default is \code{"none"}.
}
 \item{depend}{
Inverse of variance for the frailty distribution. A single value should be specified when \code{variation = "IBD"} or \code{variation = "kinship"} or a vector of two values when \code{variation = c("kinship", "IBD")}, where the first element corresponds to kinship matrix and the second element corresponds to IBD matrix.
Default is \code{NULL}.
}
 \item{base.dist}{
Choice of baseline hazard distribution.  Possible choices are: \code{"Weibull"}, \code{"loglogistic"}, \code{"Gompertz"}, \code{"lognormal"} \code{"gamma"}, \code{"logBurr"}. Default is \code{"Weibull"}.
}

  \item{base.parms}{
Vector of parameter values for the specified baseline hazard function. \code{base.parms = c(lambda, rho)} should be specified for \code{base.dist = "Weibull"}, \code{"loglogistic"}, \code{"Gompertz"}, \code{"gamma"}, and \code{"lognormal"}. For \code{base.dist = "logBurr"}, three parameters should be specified \code{base.parms = c(lambda, rho, eta)}. 
Default value is \code{base.parms = c(0.016, 3)} for \code{base.dist = "Weibull"}.
}  	
  \item{var_names}{
Names of variables to be used in generating time-to-event data. Specified variables should be part of \code{inputdata}.
  }
  \item{vbeta}{
Vector of regression coefficients for the variables specified by \code{var_names}. 
}
   \item{hr}{
Proportion of high risk families, which include at least two affected members, to be sampled from the two stage sampling. This value should be specified when \code{design="twostage"}. Default value is 0. Value should lie between 0 and 1.
}
\item{agemin}{
Minimum age of disease onset or minimum age. Default is 20 years of age.
}
}
\details{
The ages at onset are generated from the correlated frailties and covariates using the following model:

\emph{The correlated shared frailty model with kinship and/or IBD matrices}


\ifelse{html}{ \out{<p style="text-align:center"> h(t|X,Z) = h<sub>0</sub>(t - t<sub>0</sub>) Z exp( X*vbeta ), </p>}}{	
		\deqn{ h(t|X,Z) = h_0(t - t_0) Z \exp(X\beta) ,}{ h(g|X,Z) = h0(t - t0) * Z * exp(X*beta) ,}}
where \ifelse{html}{\out{h<sub>0</sub>(t)}}{\eqn{h_0(t)}{h0(t)}} is the baseline hazard function, \ifelse{html}{\out{t<sub>0</sub>}}{\eqn{t_0}{t0}} is a minimum age of disease onset, \eqn{Z} represents a vector of frailties following a multivariate log-normal distribution with mean \eqn{0} and variance \eqn{2*K*sig1 + D*sig2}, where \eqn{K} represents the kinship matrix and D is IBD matrix, \eqn{sig1} and \eqn{sig2} are variance components related to each matrix and their values are specified by \code{depend = c(1/sig1, 1/sig2)}, and \eqn{X} represents a vector of variables whose names are specified by \code{var_names}, and \ifelse{html}{\out{\beta}}{\eqn{\beta}{beta}} is a vector of corresponding coefficients whose values are specified by \code{vbeta}. 

The variance structure of the frailties shared within families is chosen by either \code{variation = "kinship"} or \code{"IBD"} matrix or both \code{variation = c("kinship", "IBD")}. 

When \code{variation = "none"}, the ages at onset are independently generated from the proportional hazard model conditional on the covariates \eqn{X}. 

The \code{design} argument defines the type of family based design to be simulated. Two variants of the population-based and clinic-based design can be chosen: \code{"pop"} when proband is affected, \code{"pop+"} when proband is affected mutation carrier, \code{"cli"} when proband is affected and at least one parent and one sibling are affected, \code{"cli+"} when proband is affected mutation-carrier and at least one parent and one sibling are affected. The two-stage design, \code{"twostage"}, is used to oversample high risk families, where the proportion of high risks families to include in the sample is specified by \code{hr}. High risk families often include multiple (at least two) affected members in the family. \code{design = "noasc"} is to be used for no ascertainment correction.

}
\value{
Returns an object of class \code{'simfam'}, a data frame which contains \code{inputdata} and the following: 
\item{ageonset}{Ages at disease onset in years.}
\item{time}{Ages at disease onset for the affected or ages of last follow-up for the unaffected. }
\item{status}{Disease statuses: 1 for affected, 0 for unaffected (censored).}
\item{fsize}{Family size including parents, siblings and children of the proband and the siblings.}
\item{naff}{Number of affected members in family.}
\item{weight}{Sampling weights.}
}
\references{
Choi, Y.-H., Briollais, L., He, W. and Kopciuk, K. (2021) FamEvent: An R Package for Generating and Modeling Time-to-Event Data in Family Designs, Journal of Statistical Software 97 (7), 1-30. doi:10.18637/jss.v097.i07

Choi, Y.-H., Kopciuk, K. and Briollais, L. (2008) Estimating Disease Risk Associated Mutated Genes in Family-Based Designs, Human Heredity 66, 238-251.

Choi, Y.-H. and Briollais (2011) An EM Composite Likelihood Approach for Multistage Sampling of Family Data with Missing Genetic Covariates, Statistica Sinica 21, 231-253.
}
\seealso{
\code{\link{summary.simfam2}, \link{plot.simfam}, \link{penplot}}
}
\examples{

## Example: simulate family data from a population-based design using
#  a Weibull distribution for the baseline hazard and inducing 
#  residual familial correlation through kinship and IBD matrices.

# Inputdata and IBD matrix should be provided; 
# simuated inputdata as an example here;

data <- simfam(N.fam = 10, design = "noasc", variation = "none",
         base.dist = "Weibull", base.parms = c(0.016, 3), vbeta = c(1, 1))

IBDmatrix <- diag(1, dim(data)[1])
data <- data[ , c(1:7, 11, 14)]

fam2 <- simfam2(inputdata = data, IBD = IBDmatrix, design = "pop", 
        variation = c("kinship","IBD"), depend = c(1, 1), 
        base.dist = "Weibull", base.parms = c(0.016, 3),
        var_names = c("gender", "mgene"), vbeta = c(1,1),
        agemin=20) 

head(fam2)

summary(fam2)

}
\keyword{Simulation}