% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcubpq.R
\name{fastcubpq}
\alias{fastcubpq}
\title{Main function for CUB models with covariates for both the uncertainty and the feeling components}
\usage{
fastcubpq(m,ordinal,Y,W,starting=NULL,maxiter,toler,iterc=3,invgen=TRUE)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of selected covariates for explaining the uncertainty component}

\item{W}{Matrix of selected covariates for explaining the feeling component}

\item{starting}{Starting values for the algorithm}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}

\item{iterc}{Iteration from which the acceleration strategy starts}

\item{invgen}{Logical: should the recursive formula for the inverse of the information matrix be considered? (Default is TRUE)}
}
\value{
An object of the class "fastCUB"
}
\description{
Estimate and validate a CUB model for given ordinal responses, with covariates for explaining both the
feeling and the uncertainty components by means of logistic transform.
}
\seealso{
\code{\link{loglikcubpq}}, \code{\link{inibestgama}}
}
\keyword{internal}
