% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_diagonal_matrix.R
\name{skew_diag_mat}
\alias{skew_diag_mat}
\title{Simulate a skewed diagonal variance matrix}
\usage{
skew_diag_mat(n = 5, shape = 1.5, scale = 1, inverse = FALSE, mean.var = NULL)
}
\arguments{
\item{n}{A scalar defining the dimensions of the variance matrix.}

\item{shape}{A scalar defining the shape of the distribution.}

\item{scale}{A scalar defining the scale of the distribution.}

\item{inverse}{When \code{TRUE} (default is \code{FALSE}), the variances are
sampled from the inverse gamma distribution instead of the gamma distribution.}

\item{mean.var}{An optional scalar defining the mean variance.
.  When supplied, the variances are scaled to achieve the defined mean.}
}
\value{
A diagonal \code{n x n} variance matrix.
}
\description{
Creates a diagonal \code{n x n} variance matrix with user-defined skewness
based on a gamma or inverse gamma distribution.
}
\examples{
# Simulate a random diagonal matrix with 10 columns and rows, and negatively skewed variances
# scaled to a mean of 0.1.
diag_mat <- skew_diag_mat(
  n = 10,
  shape = 1.5,
  scale = 1,
  mean.var = 0.1
)

}
