% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hard.thresholding.R
\name{hard.thresholding}
\alias{hard.thresholding}
\title{Hard-Thresholding Opreator on Covariance Matrix}
\usage{
hard.thresholding(sigma, threshold = 0.5)
}
\arguments{
\item{sigma}{a p*p covariance matrix}

\item{threshold}{hard-thresholding parameter}
}
\value{
a regularized covariance matrix after hard-thresholding operation
}
\description{
Apply hard-thresholding operator on a covariance matrix with 
a hard-thresholding parameter.
}
\examples{
data(m.excess.c10sp9003)
cov.SAM <- cov(m.excess.c10sp9003)
hard.thresholding(cov.SAM, threshold = 0.001)
}
\references{
"High-Dimensional Covariance Estimation" by Mohsen Pourahmadi
}

