% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pks.dur.R
\name{pks.dur}
\alias{pks.dur}
\title{Calculate the inter-event duration}
\usage{
pks.dur(Peaks)
}
\arguments{
\item{Peaks}{Output from \code{\link{pks}}.}
}
\value{
Returns a numeric vector containing the duration (in days) between peaks
  over threshold from \code{\link{pks}}. The "times" attribute contains the calendar 
  year date of the earlier peak. The "names" attribute contains the hydrologic year and
  the day (1-366) of the hydrologic year.
}
\description{
This function calculates duration (in days) between flow peaks.
}
\examples{
data(caniapiscau)
cania.ts <- create.ts(caniapiscau, hyrstart = 4)
cania.ts <- drop.years(cania.ts)
cania.ts <- set.plot.titles(cania.ts, 
title.elements = c("StationID", "StnName", "StateProv"))

res1 <- pks(cania.ts)
res2 <- pks.dur(res1)
res3 <- screen.metric(res2, ylabel = "Inter-Event Duration (days)")
}
\author{
Jennifer Dierauer
}
