% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reco_heu.R
\name{iterec}
\alias{iterec}
\title{Iterative cross-temporal reconciliation}
\usage{
iterec(base, cslist, telist, res = NULL, itmax = 100, tol = 1e-5,
       type = "tcs", norm = "inf", verbose = TRUE)
}
\arguments{
\item{base}{A (\eqn{n \times h(k^\ast+m)}) numeric matrix containing the base forecasts to
be reconciled; \eqn{n} is the total number of variables, \eqn{m} is the max. order of temporal
aggregation, \eqn{k^\ast} is the sum of (a subset of) (\eqn{p-1}) factors of \eqn{m},
excluding \eqn{m}, and \eqn{h} is the forecast horizon for the lowest frequency time series.
The row identifies a time series, and the forecasts in each row are ordered from the
lowest frequency (most temporally aggregated) to the highest frequency.}

\item{cslist}{A list of elements for the cross-sectional reconciliation.
See \link{csrec} for a complete list (excluded \code{base} and \code{res}).}

\item{telist}{A list of elements for the temporal reconciliation.
See \link{terec} for a complete list (excluded \code{base} and \code{res}).}

\item{res}{A (\eqn{n \times N(k^\ast+m)}) optional numeric matrix containing the
in-sample residuals at all the temporal frequencies ordered from the lowest frequency
to the highest frequency (columns) for each variable (rows). This matrix is used
to compute some covariance matrices.}

\item{itmax}{Max number of iteration (\code{100}, \emph{default}).}

\item{tol}{Convergence tolerance (\code{1e-5}, \emph{default}).}

\item{type}{A string specifying the uni-dimensional reconciliation order:
temporal and then cross-sectional ("\code{tcs}") or cross-sectional and
then temporal ("\code{cst}").}

\item{norm}{Norm used to calculate the temporal and the cross-sectional
incoherence: infinity norm ("\code{inf}", \emph{default}), one norm ("\code{one}"), and
2-norm ("\code{two}").}

\item{verbose}{If \code{TRUE}, reconciliation information are printed.}
}
\value{
A (\eqn{n \times h(k^\ast+m)}) numeric matrix of cross-temporal reconciled forecasts.
}
\description{
This function performs the iterative procedure described in Di Fonzo and Girolimetto (2023),
which produces cross-temporally reconciled forecasts by alternating forecast
reconciliation along one single dimension (either cross-sectional or temporal)
at each iteration step.
}
\examples{
set.seed(123)
# (3 x 7) base forecasts matrix (simulated), Z = X + Y and m = 4
base <- rbind(rnorm(7, rep(c(20, 10, 5), c(1, 2, 4))),
              rnorm(7, rep(c(10, 5, 2.5), c(1, 2, 4))),
              rnorm(7, rep(c(10, 5, 2.5), c(1, 2, 4))))
# (3 x 70) in-sample residuals matrix (simulated)
res <- rbind(rnorm(70), rnorm(70), rnorm(70))

A <- t(c(1,1)) # Aggregation matrix for Z = X + Y
m <- 4 # from quarterly to annual temporal aggregation

rite <- iterec(base = base,
               cslist = list(agg_mat = A, comb = "shr"),
               telist = list(agg_order = m, comb = "wlsv"),
               res = res)

}
\references{
Di Fonzo, T. and Girolimetto, D. (2023), Cross-temporal forecast reconciliation:
Optimal combination method and heuristic alternatives, \emph{International Journal
of Forecasting}, 39, 1, 39-57. \doi{10.1016/j.ijforecast.2021.08.004}
}
\seealso{
Cross-temporal framework: 
\code{\link{ctboot}()},
\code{\link{ctbu}()},
\code{\link{ctcov}()},
\code{\link{ctlcc}()},
\code{\link{ctmo}()},
\code{\link{ctrec}()},
\code{\link{cttd}()},
\code{\link{cttools}()},
\code{\link{tcsrec}()}
}
\concept{Framework: cross-temporal}
