% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForLion_MLM_Optimal.R
\name{ForLion_MLM_Optimal}
\alias{ForLion_MLM_Optimal}
\title{ForLion function for multinomial logit models}
\usage{
ForLion_MLM_Optimal(
  J,
  n.factor,
  factor.level,
  var_names = NULL,
  xlist_fix = NULL,
  hfunc,
  h.prime,
  bvec,
  link = "continuation",
  Fi.func = Fi_MLM_func,
  delta0 = 1e-05,
  epsilon = 1e-12,
  reltol = 1e-05,
  delta = 0,
  maxit = 100,
  random = FALSE,
  nram = 3,
  rowmax = NULL,
  Xini = NULL,
  random.initial = FALSE,
  nram.initial = 3,
  optim_grad = FALSE
)
}
\arguments{
\item{J}{number of response levels in the multinomial logit model}

\item{n.factor}{Vector of numbers of distinct levels, “0” indicating continuous factors that always come first, “2” or more for discrete factors, and “1” not allowed.}

\item{factor.level}{list of distinct factor levels, “(min, max)” for continuous factors that always come first, finite sets for discrete factors.}

\item{var_names}{Names for the design factors. Must have the same length asfactor.level. Defaults to "X1", "X2", ...}

\item{xlist_fix}{list of discrete factor experimental settings under consideration, default NULL indicating a list of all possible discrete factor experimental settings will be used.}

\item{hfunc}{function for generating the corresponding model matrix or predictor vector, given an experimental setting or design point.}

\item{h.prime}{function to obtain dX/dx}

\item{bvec}{assumed parameter values of model parameters beta, same length of h(y)}

\item{link}{link function, default "continuation", other choices "baseline", "cumulative", and "adjacent"}

\item{Fi.func}{function to calculate row-wise Fisher information Fi, default is Fi_MLM_func}

\item{delta0}{merging threshold for initial design, such that, || x_i(0) - x_j(0) || >= delta0, default 1e-5}

\item{epsilon}{tuning parameter as converging threshold, such that, a nonnegative number is regarded as numerical zero if less than epsilon, default 1e-12.}

\item{reltol}{the relative convergence tolerance, default value 1e-5}

\item{delta}{relative difference as merging threshold for the merging step, the distance of two points less than delta may be merged, default 0, can be different from delta0 for the initial design.}

\item{maxit}{the maximum number of iterations, default value 100}

\item{random}{TRUE or FALSE, whether or not to repeat the lift-one step multiple times with random initial allocations, default FALSE.}

\item{nram}{number of times repeating the lift-one step with random initial allocations, valid only if random is TRUE, default 3.}

\item{rowmax}{maximum number of points in the initial design, default NULL indicates no restriction}

\item{Xini}{initial list of design points, default NULL indicating automatically generating an initial list of design points.}

\item{random.initial}{TRUE or FALSE, whether or not to repeat the whole procedure multiple times with random initial designs, default FALSE.}

\item{nram.initial}{number of times repeating the whole procedure with random initial designs, valid only if random.initial is TRUE, default 3.}

\item{optim_grad}{TRUE or FALSE, default is FALSE, whether to use the analytical gradient function or numerical gradient when searching for a new design point.}
}
\value{
m             the number of design points

x.factor      matrix of experimental factors with rows indicating design point

p             the reported D-optimal approximate allocation

det           the determinant of the maximum Fisher information

convergence   TRUE or FALSE, whether converge

min.diff      the minimum Euclidean distance between design points

x.close       pair of design points with minimum distance

itmax         iteration of the algorithm
}
\description{
Function for ForLion algorithm to find D-optimal design under multinomial logit models with mixed factors.
Reference Section 3 of Huang, Li, Mandal, Yang (2024).
Factors may include discrete factors with finite number of distinct levels and continuous factors with specified interval range (min, max), continuous factors, if any, must serve as main-effects only, allowing merging points that are close enough.
Continuous factors first then discrete factors, model parameters should in the same order of factors.
}
\examples{
m=5
p=10
J=5
link.temp = "cumulative"
n.factor.temp = c(0,0,0,0,0,2)  # 1 discrete factor w/ 2 levels + 5 continuous
## Note: Always put continuous factors ahead of discrete factors,
## pay attention to the order of coefficients paring with predictors
factor.level.temp = list(c(-25,25), c(-200,200),c(-150,0),c(-100,0),c(0,16),c(-1,1))
hfunc.temp = function(y){
if(length(y) != 6){stop("Input should have length 6");}
 model.mat = matrix(NA, nrow=5, ncol=10, byrow=TRUE)
 model.mat[5,]=0
 model.mat[1:4,1:4] = diag(4)
 model.mat[1:4, 5] =((-1)*y[6])
 model.mat[1:4, 6:10] = matrix(((-1)*y[1:5]), nrow=4, ncol=5, byrow=TRUE)
 return(model.mat)
 }
bvec.temp=c(-1.77994301, -0.05287782,  1.86852211, 2.76330779, -0.94437464, 0.18504420,
-0.01638597, -0.03543202, -0.07060306, 0.10347917)

h.prime.temp = NULL #use numerical gradient (optim_grad=FALSE)
ForLion_MLM_Optimal(J=J, n.factor=n.factor.temp, factor.level=factor.level.temp, xlist_fix=NULL,
hfunc=hfunc.temp,h.prime=h.prime.temp, bvec=bvec.temp, link=link.temp, optim_grad=FALSE)


}
