% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_ccircle_spatial_notrees.R
\name{fe_ccircle_spatial_notrees}
\alias{fe_ccircle_spatial_notrees}
\title{User Friendly Construction of an \strong{fe_ccircle_spatial_notrees} Object from a
List of Data Frames}
\usage{
fe_ccircle_spatial_notrees(
  x,
  time_yr_name = "time_yr",
  circle_frame_name = "circle_definition",
  center_coord = "center_coordinate",
  small_trees_name = "small_trees",
  stand_id = "my_fe_ccircle_spatial_notrees"
)
}
\arguments{
\item{x}{Named list to be coerced into the goal object.}

\item{time_yr_name}{name of the element of \code{x} which contains the
required time information, i.e. a single (calendar) year or vector of years
in order to give the object a time relation. If small tree information is
present (i.e. the small tree data frame is not empty), \code{time_yr} must
absolutely match with the \code{time_yr} column of this data frame.}

\item{circle_frame_name}{Name of the data frame in \code{x} that contains the
definition of the concentric circles. It must contain the lower and the
upper dbh limits, the circle area in Ha, and the slope in degrees. If the
slope is not given it will be set to 0.}

\item{center_coord}{Name of the sf object that contains the center coordinate
of the circles with coordinate reference system (either Gauss Kruger or
UTM). If it is not provided the center will be c(0,0) by the default}

\item{small_trees_name}{Name of the object that contains the information
regarding the small trees (generally those trees that do no have any dbh
because of having a height below 1.3 m). This object is still experimental,
so the only requirement for it is that it has to be a data frame without
any further specification. Useful standard information in this data frame
are the tree id, the height and represenation area.}

\item{stand_id}{arbitrary id of the stand (\code{character}, default:
"my_fe_ccircle_spatial")}
}
\value{
If the user input allows to construct a well-defined
\code{fe_ccircle_spatial_notrees} object, this object will be returned. If
not, the function will terminate with an error.
}
\description{
\code{fe_ccircle_spatial_notrees()} provides a user-friendly interface for
the constructor \code{\link{new_fe_ccircle_spatial_notrees}}. While the
constructor does not prevent users from creating malformed
\code{new_fe_ccircle_spatial_notrees} objects,
\code{new_fe_ccircle_spatial_notrees} does everything to achieve a
well-defined object mostly based on an initial list of data.frames that might
be, e.g. drawn out of a user's own data base.
}
\details{
An object of class \code{fe_ccircle_spatial_notrees} is a child object of
\code{\link{fe_ccircle_spatial}} which, however does not contain trees which
are big enough to have a dbh. So, in contrast to
\code{\link{fe_ccircle_spatial}} objects, where the elements \code{trees},
and \code{tree_positions} must be data frames, both are \code{NULL} in this
class. The class \code{fe_ccircle_spatial_notrees} has been designed for
covering a comparably rare case, i.e. an inventory point where no regular
trees (trees that are big enough to have a dbh), but possibly small trees are
present. The input object \code{x} to \code{fe_ccircle_spatial} must be a
list that follows the same conventions as the input object of
\code{\link{fe_ccircle_spatial}}, except that no tree data frame is required.
If it does exist, it will be ignored. In addition to the input object of
\code{\link{fe_ccircle_spatial}}, there is one additional list element needed
which defines a single (calendar) year or a vector of years in order to give
the object a time relation. If small tree information is present (i.e. the
small tree data frame is not empty), \code{time_yr} must absolutely match
with the \code{time_yr} column of this data frame.
}
\examples{
# Transform the example data collection mm_forest_1_raw (could e.g. have
# been drawn out of a user's data base) into an fe_ccircle_spatial_notrees
# object. This means, that in the resulting data frame the trees and their
# positions are ignored.
notrees_example <- spruce_pine_ccircle_raw |>
  fe_ccircle_spatial_notrees()

plot(notrees_example)

}
