% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEL.R
\name{PEL}
\alias{PEL}
\title{Pseudo empirical likelihood estimator}
\usage{
PEL(ysA, ysB, pi_A, pi_B, domains_A, domains_B, N_A = NULL, N_B = NULL, 
N_ab = NULL, xsAFrameA = NULL, xsBFrameA = NULL, xsAFrameB = NULL, xsBFrameB = NULL, 
XA = NULL, XB = NULL, conf_level = NULL)
}
\arguments{
\item{ysA}{A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{c} containing information about variable(s) of interest from \eqn{s_A}.}

\item{ysB}{A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{c} containing information about variable(s) of interest from \eqn{s_B}.}

\item{pi_A}{A numeric vector of length \eqn{n_A} or a square numeric matrix of dimension \eqn{n_A} containing first order or first and second order inclusion probabilities for units included in \eqn{s_A}.}

\item{pi_B}{A numeric vector of length \eqn{n_B} or a square numeric matrix of dimension \eqn{n_B} containing first order or first and second order inclusion probabilities for units included in \eqn{s_B}.}

\item{domains_A}{A character vector of size \eqn{n_A} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "a" and "ab".}

\item{domains_B}{A character vector of size \eqn{n_B} indicating the domain each unit from \eqn{s_B} belongs to. Possible values are "b" and "ba".}

\item{N_A}{(Optional) A numeric value indicating the size of frame A.}

\item{N_B}{(Optional) A numeric value indicating the size of frame B.}

\item{N_ab}{(Optional) A numeric value indicating the size of the overlap domain.}

\item{xsAFrameA}{(Optional) A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, containing auxiliary information in frame A for units included in \eqn{s_A}.}

\item{xsBFrameA}{(Optional) A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, containing auxiliary information in frame A for units included in \eqn{s_B}. For units in domain \eqn{b}, these values are 0.}

\item{xsAFrameB}{(Optional) A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, containing auxiliary information in frame B for units included in \eqn{s_A}. For units in domain \eqn{a}, these values are 0.}

\item{xsBFrameB}{(Optional) A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, containing auxiliary information in frame B for units included in \eqn{s_B}.}

\item{XA}{(Optional) A numeric value or vector of length \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, indicating the population totals for the auxiliary variables considered in frame A.}

\item{XB}{(Optional) A numeric value or vector of length \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, indicating the population totals for the auxiliary variables considered in frame B.}

\item{conf_level}{(Optional) A numeric value indicating the confidence level for the confidence intervals, if desired.}
}
\value{
\code{PEL} returns an object of class "EstimatorDF" which is a list with, at least, the following components:
 \item{Call}{the matched call.}
 \item{Est}{total and mean estimation for main variable(s).}
 \item{VarEst}{variance estimation for main variable(s).}
 If parameter \code{conf_level} is different from \code{NULL}, object includes component
 \item{ConfInt}{total and mean estimation and confidence intervals for main variables(s).}
 In addition, components \code{TotDomEst} and \code{MeanDomEst} are available when estimator is based on estimators of the domains. Component \code{Param} shows value of parameters involded in calculation of the estimator (if any).
 By default, only \code{Est} component (or \code{ConfInt} component, if parameter \code{conf_level} is different from \code{NULL}) is shown. It is possible to access to all the components of the objects by using function \code{summary}.
}
\description{
Produces estimates for population totals using the pseudo empirical likelihood estimator from survey data obtained
 from a dual frame sampling design. Confidence intervals for the population total are also computed, if required.
}
\details{
Pseudo empirical likelihood estimator for the population mean is computed as
 \deqn{\hat{\bar{Y}}_{PEL} = \frac{N_a}{N}\hat{\bar{Y}}_a + \frac{\eta N_{ab}}{N}\hat{\bar{Y}}_{ab}^A + \frac{(1 - \eta) N_{ab}}{N}\hat{\bar{Y}}_{ab}^B + \frac{N_b}{N}\hat{\bar{Y}}_b}
 where \eqn{\hat{\bar{Y}}_a = \sum_{k \in s_a}\hat{p}_{ak}y_k, \hat{\bar{Y}}_{ab} = \sum_{k \in s_{ab}^A}\hat{p}_{abk}^Ay_k, \hat{\bar{Y}}_{ab}^B = \sum_{k \in s_{ab}^B}\hat{p}_{abk}^By_k}
 and \eqn{\hat{\bar{Y}}_b = \sum_{k \in s_b}\hat{p}_{bk}y_k} with \eqn{\hat{p}_{ak}, \hat{p}_{abk}^A, \hat{p}_{abk}^B} and \eqn{\hat{p}_{bk}} the weights resulting of applying the pseudo empirical likelihood procedure to a determined function under a determined set of constraints, depending on the case. 
 Furthermore, \eqn{\eta \in (0,1)}. In this case, \eqn{N_A, N_B} and \eqn{N_{ab}} have been supposed known and no additional auxiliary variables have been considered. This is not happening in some cases.
 Function covers following scenarios:
 \itemize{
\item There is not any additional auxiliary variable 
     \itemize{
     	\item \eqn{N_A, N_B} and \eqn{N_{ab}} unknown
             \item \eqn{N_A} and \eqn{N_B} known and \eqn{N_{ab}} unknown
             \item \eqn{N_A, N_B} and \eqn{N_{ab}} known
     }
     \item At least, one additional auxiliary variable is available 
     \itemize{
             \item \eqn{N_A} and \eqn{N_B} known and \eqn{N_{ab}} unknown
             \item \eqn{N_A, N_B} and \eqn{N_{ab}} known
     }
 }
 Explicit variance of this estimator is not easy to obtain. Instead, confidence intervals can be computed through the bi-section method. This method constructs intervals in the form \eqn{\{\theta|r_{ns}(\theta) < \chi_1^2(\alpha)\}}, 
 where \eqn{\chi_1^2(\alpha)} is the \eqn{1 - \alpha} quantile from a \eqn{\chi^2} distribution with one degree of freedom and \eqn{r_{ns}(\theta)} represents the so called pseudo empirical log likelihood ratio statistic, 
 which can be obtained as a difference of two pseudo empirical likelihood functions.
}
\examples{
data(DatA)
data(DatB)
data(PiklA)
data(PiklB)

#Let calculate pseudo empirical likelihood estimator for variable Feeding, without
#considering any auxiliary information
PEL(DatA$Feed, DatB$Feed, PiklA, PiklB, DatA$Domain, DatB$Domain)

#Now, let calculate pseudo empirical estimator for variable Clothing when the frame
#sizes and the overlap domain size are known
PEL(DatA$Clo, DatB$Clo, PiklA, PiklB, DatA$Domain, DatB$Domain, 
N_A = 1735, N_B = 1191, N_ab = 601)

#Finally, let calculate pseudo empirical likelihood estimator and a 90\% confidence interval
#for population total for variable Feeding, considering Income and Metres2 as auxiliary 
#variables and with frame sizes and overlap domain size known.
PEL(DatA$Feed, DatB$Feed, PiklA, PiklB, DatA$Domain, DatB$Domain, 
N_A = 1735, N_B =  1191, N_ab = 601, xsAFrameA = DatA$Inc, xsBFrameA = DatB$Inc, 
xsAFrameB = DatA$M2, xsBFrameB = DatB$M2, XA = 4300260, XB = 176553, 
conf_level = 0.90)
}
\references{
Rao, J. N. K. and Wu, C. (2010)
\emph{Pseudo Empirical Likelihood Inference for Multiple Frame Surveys}.
Journal of the American Statistical Association, 105, 1494 - 1503.

Wu, C. (2005)
\emph{Algorithms and R codes for the pseudo empirical likelihood methods in survey sampling}.
Survey Methodology, Vol. 31, 2, pp. 239 - 243.
}
\seealso{
\code{\link{JackPEL}}
}

