% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AR1_FRAILTY.R
\name{AR1_FRAILTY}
\alias{AR1_FRAILTY}
\title{Fit a Functional Regression with AutoregressIve fraiLTY (FRAILTY) model for Recurrent Event Data}
\usage{
AR1_FRAILTY(
  formula,
  sdat,
  fdat,
  para0 = c(0.5, 0.5),
  nbasis = 10,
  pve = 0.9,
  npc = NULL,
  makePD = FALSE,
  cov.weight.type = c("none", "counts"),
  iter.max = 50,
  eps = 1e-06
)
}
\arguments{
\item{formula}{A formula, with the response on the left of a ~ operator being a \code{Recur} object as returned by function \code{Recur} in \strong{reda},
and scalar covariates on the right.}

\item{sdat}{A data frame containing subject IDs,  time-to-event outcomes (starting time, end point, censoring time and event status), and scalar covariates}

\item{fdat}{A data frame containing subject IDs, longitudinal measurements, and the corresponding time points for each measurement.}

\item{para0}{A vector of initial values for \eqn{\theta^2} and auto-regressive coefficient \eqn{\rho}. Both default to 0.5.}

\item{nbasis}{An integer, representing the number of B-spline basis functions
used for estimation of the mean function and bivariate smoothing of the covariance surface.
Defaults to \code{10} (cf. \code{fpca.sc} in \strong{refund}).}

\item{pve}{A numeric value between 0 and 1, the proportion of variance
explained: used to choose the number of principal components. Defaults to
\code{0.9} (cf. \code{fpca.sc} in \strong{refund}).}

\item{npc}{An integer, giving a prespecified value for the number of
principal components. Defaults to \code{NULL}. If given, this overrides
\code{pve} (cf. \code{fpca.sc} in \strong{refund}).}

\item{makePD}{Logical: should positive definiteness be enforced for the
covariance surface estimate? Defaults to \code{FALSE} (cf.
\code{fpca.sc} in \strong{refund}).}

\item{cov.weight.type}{The type of weighting used for the smooth covariance
estimate. Defaults to \code{"none"}, i.e. no weighting. Alternatively,
\code{"counts"} (corresponds to \code{fpca.sc} in \strong{refund}) weights the
pointwise estimates of the covariance function by the number of observation
points.}

\item{iter.max}{Maximum number of iterations for both inner iteration and outer iteration. Defaults to \code{50}.}

\item{eps}{Tolerance criteria for a possible infinite coefficient value. Defaults to \code{1e-6}.}
}
\value{
A funsurv object containing the following components:
\item{beta}{Estimation of coefficients of scalar covariates and FPC scores.
Including estimated values, standard errors, and p-values}
\item{beta_vcov}{Estimated variance-covariance of the estimates of beta}
\item{eAR}{Estimation of variance components (\eqn{\theta^2} and \eqn{\rho})}
\item{eAR_vcov}{Estimated variance of estimates of \eqn{\theta^2} and \eqn{\rho}}
\item{frailties}{Estimated frailty terms (random effects)}
\item{basesurv}{Estimated baseline survival probability}
\item{time}{Time points associated with baseline survival probability}
\item{FPC}{Functional principal components}
}
\description{
Jointly model longitudinal measurements and recurrent events,
accommodating both scalar and functional predictors while capturing time-dependent correlations among events.
The FRAILTY method employs a two-step estimation procedure.
First, functional principal component analysis through conditional expectation (PACE) is applied to extract
key temporal features from sparse, irregular longitudinal data.
Second, the obtained scores are incorporated into a dynamic recurrent frailty model
with an autoregressive structure to account for within-subject correlations across recurrent events.
This function works only for univariate functional data.
}
\details{
\bold{Model specification: }

Let \eqn{T_{ij}} denote the time of the \eqn{j}th event for subject \eqn{i},
and let \eqn{C_i} represent the censoring time.
The observed event time, accounting for right censoring, is \eqn{\widetilde{T}_{ij}=\min(T_{ij}, C_i)},
and \eqn{\delta_{ij}=I(T_{ij}\leq C_i)} serves as an indicator of whether the \eqn{j}th event for subject \eqn{i} is observed.
The hazard function is specified as
\deqn{h(t; \boldsymbol{Z}_i, {X}_i(\cdot))=h_{0}(t-t_{i,j-1}) \exp \left(\eta_{ij}\right),}
where \eqn{h_0(\cdot)} is the baseline hazard function,
and \eqn{\eta_{ij} = \bm{\alpha}^{\top}\boldsymbol{Z}_i +\int_{t_{i, j-1}}^{t}{X}_{i}(s)\beta(s)ds + v_{ij}}.
Here, \eqn{t_{i, j-1}} is the previous event time with \eqn{t_{i0} = 0}.
\eqn{\bm{\alpha}} is the fixed effect parameter associated with the time-invariant covariates \eqn{\boldsymbol{Z}_i},
and \eqn{\beta(t)} is a time-varying coefficient that captures the effect of functional predictor \eqn{X_{i}(t)} on the hazard rate of recurrent events.
}
\examples{
data(simDat)

fit <- AR1_FRAILTY(Recur(t_start \%to\% t_stop, id, status) ~ z1,
                   sdat = sdat, fdat = fdat, iter.max = 30)

summary(fit)
}
\seealso{
\code{\link[reda]{Recur}}

\code{\link[MFPCA]{PACE}}
}
