% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData2.R
\name{simData2}
\alias{simData2}
\title{Generate simulated data for \code{\link{SNPinter}} and \code{\link{SNPcvinter}}}
\usage{
simData2(n, m, seed)
}
\arguments{
\item{n}{an interger variable specifying the number of samples to be generated.}

\item{m}{an interger variable specifying the sequence length of each sample.}

\item{seed}{an integer variable specifyinging the random seed used for random sequence generation.}
}
\value{
An "simData2" object that contains the list of the following items.
\itemize{
\item{y:}{ a numeric vector representing the response variables.}
\item{z:}{ a matrix representing the scalar covariates, with the number of rows equal to the number of samples.}
\item{location:}{ a numeric vector defining the sampling sites of the sequence (genotypes) data.}
\item{X:}{ a matrix representing the sequence data, with the number of rows equal to the number of samples.}
\item{beta:}{ an "fd" object specifying the genetic effect function.}
}
}
\description{
Generate simulated data for users to apply the method SNPinter and SNPcvinter, including response variable y, scalar variable Z and sequence (genotypes) data X.
}
\examples{
library(FunctanSNP)
n <- 300
m <- 30
simdata2 <- simData2(n, m, seed = 123)

}
\seealso{
See Also as \code{\link{simData1}}, \code{\link{SNPinter}}, \code{\link{SNPcvinter}}.
}
