% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{cmp.firing}
\alias{cmp.firing}
\title{Plot firing strength with different inference method}
\usage{
cmp.firing(
  IP,
  mfType,
  mfPara,
  fuzMethod,
  fuzPara,
  SFLS = TRUE,
  STD = TRUE,
  CEN = FALSE,
  SIM = FALSE,
  step = 100,
  fisRange = NULL
)
}
\arguments{
\item{IP}{A matrix representing the input stack, number of inputs (columns) by number of outputs (rows).}

\item{mfType}{The type of fuzzy membership function\cr}

\item{mfPara}{The parameters for the given type of membership function\cr}

\item{fuzMethod}{The type of fuzzy membership function for non-singleton fuzzification}

\item{fuzPara}{The parameters for the given fuz.type of membership function}

\item{SFLS}{When TRUE, shows the firing strength produced by SFLS}

\item{STD}{When TRUE, shows the firing strength produced by std-NSFLS}

\item{CEN}{When TRUE, shows the firing strength produced by cen-NSFLS}

\item{SIM}{When TRUE, shows the firing strength produced by sim-NSFLS}

\item{step}{For discrete fuzzification}

\item{fisRange}{Field of definition, for example, c(1,10)}
}
\value{
A two dimensional graph displaying all the firing strength produced by given method.
}
\description{
Plots a 2D graph of the firing strength for a antecedent produced by different inference method
}
\examples{
cmp.firing(1, 'gaussmf', c(1, 2.5, 1), 'gbell', c(0.4, 2), step=100)

}
\author{
Yu Zhao
}
