% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gagblup.R
\name{gagblup}
\alias{gagblup}
\title{Genetic algorithm assisted genomic best liner unbiased prediction for genomic selection}
\usage{
gagblup(
  genotype,
  phenotype,
  fit_fun = "HAT",
  maxiter = 2000,
  nfold = 10,
  nTimes = 1,
  seed = 123,
  n_core = 1
)
}
\arguments{
\item{genotype}{a matrix for genotypes in numeric format, with individuals in rows and markers in cols.}

\item{phenotype}{a vector of phenotype, missing (NA) values are not allowed.}

\item{fit_fun}{the fitness function. There are four options: fitness = "AIC"/"BIC"/"FIT"/"HAT", default is "HAT"}

\item{maxiter}{max number of iterations for GAGBLUP, default is 2000}

\item{nfold}{the number of folds. Default is 10.}

\item{nTimes}{the number of independent replicates for the cross-validation. Default is 1.}

\item{seed}{the random number. Default is 123.}

\item{n_core}{the number of CPU to be used, default is 1.}
}
\value{
A list with following information is returned:
        $R2  the squared pearson correlation coefficient between the true value and the predicted value,
        $predicted_value  the predicted value and the true value of the phenotype,
        $marker_selection  a vector of the selected markers, with 1 indicates selected, 0 indicates not selected.
}
\description{
Performs genomic selection with genetic algorithm assisted genomic best liner unbiased prediction
}
\examples{
## load example data from GAGBLUP package
data(phenotype)
data(bins)
phenotype <- phenotype[1:200,3]
result <- gagblup(bins[1:200,],phenotype,fit_fun='HAT',maxiter=1,nfold=2,nTimes=1,seed=123,n_core=1)
}
