#' @export
#' @keywords internal
Likelihood.GARCHX <- function(fit, sigma.init, n, eps.delta, null = FALSE){
  # Assign omega, alpha, beta, and pi coefficients values
  omega <- fit$omega
  alpha <- fit$alpha
  beta <- fit$beta
  pi <- fit$pi

  # Initialize h
  h <- rep(0, n)

  # h^{1/δ_0}_1
  h[1] <- sigma.init^{fit$delta/2}

  # Convert boolean to number
  w <- as.numeric(!null)

  # ht=ω0+ qi=1 α0i+(ε+t−i)δ0+α0i−(ε− t−i)δ0 + pj=1β0jht−j+π′0xt−1
  for(t in 2:n){
    h[t] <- omega + alpha * eps.delta[t-1] + beta * h[t-1] + w * drop(fit$selectedX[t-1,] %*% pi)
  } # End for

  # Calculate sigma^2
  sigma <- h^(2/fit$delta)

  # Calculate QMLE
  qml <- mean(log(sigma[(fit$r+1):n]) + fit$eps[(fit$r+1):n]**2/sigma[(fit$r+1):n])

  # Return QMLE
  qml
} # End Likelihood.GARCHXselect












