% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARCHX.R
\name{GARCHX}
\alias{GARCHX}
\title{Fitting GARCHX model for variable selection}
\usage{
GARCHX(
  eps,
  X,
  order = c(1, 1),
  delta = 2,
  optim.method = "NR"
)
}
\arguments{
\item{eps}{Time series}

\item{X}{Matrix with exogenous covariates where the number of rows is equal to the length of eps}

\item{order}{Order of the GARCH model. Value of p cannot be 0}

\item{delta}{Value of the power of the main time series to allow for Power GARCHX, default is 2 for GARCHX}

\item{optim.method}{Optimization method for maximizing quasi-likelihood function. Options: "NR", "L-BFGS-B", "GA", "PS", "SA". Default value is "NR"}
}
\value{
An object of class GARCHX
}
\description{
Fits a GARCHX model with given data and estimates the coefficients for omega, alpha, beta, and pi
}
\details{
Uses the GARCHX model \deqn{\mathcal{E}_t = \sigma_tw_t}
\deqn{\sigma^2_t = \omega_0 + \sum^{p}_{i=1}\alpha_i\mathcal{E}_{t-i}^2 + \sum^q_{j=1}\beta_j\sigma^2_{t-j}+\mathbf{\pi}^T\mathbf{x}_{t-1}}

To estimate the coefficients for \deqn{\omega, \alpha, \beta, \pi}.
No variable selection is done in this function.
}
