% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_input.R
\name{parse_input}
\alias{parse_input}
\title{parse_input.R}
\usage{
parse_input(test_stats, cor_mat = NULL, pairwise_cors = NULL)
}
\arguments{
\item{test_stats}{All test statistics in the set}

\item{cor_mat}{The correlation matrix of the test statistics}

\item{pairwise_cors}{The vector of all pairwise correlations}
}
\value{
A list with the elements:
\item{t_vec}{The sorted magnitudes of test statistics}
\item{pairwise_cors}{The vector of all pairwise correlations}
}
\description{
Internal function to accept the input as unsorted Z-statistics and either a matrix
or vector of correlations, and return the t_vec and pairwise_cors. Also do limited
error checking.
}
\examples{
parse_input(test_stats=rnorm(5), pairwise_cors=rep(0.3,10))
}
\keyword{internal}
