% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neagging.R
\name{neagging}
\alias{neagging}
\title{Normalized Entropy Aggregation for Inhomogeneous Large-Scale Data - Neagging}
\usage{
neagging(
  object,
  boot.B = ifelse(object$boot.B == 0, 100, object$boot.B),
  boot.method = object$boot.method,
  error = object$error
)
}
\arguments{
\item{object}{Fitted \code{\link{lmgce}} or \code{\link{tsbootgce}} model
object.}

\item{boot.B}{To use with a \code{\link{lmgce}} object. A single positive
integer greater or equal to 10 for the number of bootstrap replicates for the
computation of the Normalized Entropy Aggregation estimate(s), to be used
when \code{object} was created with \code{boot.B = 0}. The default is
\code{boot.B = 100} when the \code{object} has no previous sampling
information and \code{boot.B = object$boot.B} otherwise, which corresponds
to the \code{boot.B} given to \code{lmgce} when the \code{object} was created.}

\item{boot.method}{To use with a \code{\link{lmgce}} object. Method used for
bootstrapping. One of \code{c("residuals", "cases", "wild")} which corresponds
to resampling on residuals, on individual cases or on residuals multiplied by
 a N(0,1) variable, respectively. The default is
 \code{boot.method = object$boot.method}.}

\item{error}{Loss function (error) to be used for the selection
of the support spaces. One of c("RMSE","MSE", "MAE", "MAPE", "sMAPE", "MASE").
The default is \code{boot.method = object$error}.}
}
\value{
An object of \code{\link[base]{class}} \code{neagging} is a list containing
 at least the following components:

\item{matrix}{a matrix where each column contains sequentially the aggregated
 estimates.}
\item{error}{a named vector with the in sample error for each aggregated set
of estimates.}
\item{error.object}{the in sample error of the \code{object}.}
\item{coefficients}{the aggregated coefficients that produced the lowest in
sample error.}
\item{coefficients.object}{the coefficients of the \code{object}.}
}
\description{
Computes the estimates for the Normalized Entropy Aggregation
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)

neagging(res_gce_package, boot.method = "cases")

res.tsbootgce <-
  tsbootgce(
    formula = CO2 ~ 1 + L(GDP, 1) + L(EPC, 1) + L(EU, 1),
    data = moz_ts)

neagging(res.tsbootgce)
}

}
\references{
da Conceição Costa, M. and Macedo, P. (2019).
\emph{Normalized Entropy Aggregation for Inhomogeneous Large-Scale Data.}
In O. Valenzuela, F. Rojas, H. Pomares, & I. Rojas (Eds.), Theory and Applications of Time Series Analysis (pp. 19–29).
Springer International Publishing.
\doi{10.1007/978-3-030-26036-1_2}
}
\seealso{
The generic functions \code{\link{plot.neagging}} and
\code{\link{coef.neagging}}.
}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
