% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{residuals.lmgce}
\alias{residuals.lmgce}
\title{Extract \code{\link{lmgce}} Model Residuals}
\usage{
\method{residuals}{lmgce}(object, ...)
}
\arguments{
\item{object}{Fitted \code{\link{lmgce}} model object.}

\item{...}{additional arguments.}
}
\value{
Returns the residuals from a \code{\link{lmgce}} object
}
\description{
\code{residuals} is a function which extracts model residuals from
\code{\link{lmgce}} objects.
The abbreviated form \code{resid} is an alias for \code{residuals}.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}
residuals(res_gce_package)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
